
library(Seurat)
WT.data <- Read10X_h5("WT-SP.h5")#read data
WT <- CreateSeuratObject(counts = WT.data, project = "IMMUNE_stim", min.cells = 5) #CreateSeuratObject
WT$stim <- "WT" #groub
WT <- subset(x = WT, subset = nFeature_RNA > 500) 
WT <- NormalizeData(object = WT, verbose = FALSE) #normalizetion
#WT <- FindVariableFeatures(object = WT, selection.method = "vst", nfeatures = 2000) #findvariablefeatures
tcr <- read.csv("WT-filtered_contig_annotations.csv")
clono <- read.csv("WT-clonotypes.csv")
tcr <- tcr[!duplicated(tcr$barcode), ]
names(tcr)[names(tcr) == "raw_clonotype_id"] <- "clonotype_id"
#clono <- read.csv("clonotypes.csv")
tcr <- merge(tcr, clono)
rownames(tcr) <- tcr[,2]
tcr[,2] <- NULL
WT <- AddMetaData(object=WT, metadata=tcr)
#aa=WT@meta.data
HT.data  <- Read10X_h5("HT-SP.h5")
HT <- CreateSeuratObject(counts = HT.data, project = "IMMUNE_stim", min.cells = 5)
HT$stim <- "HT"
HT <- subset(x = HT, subset = nFeature_RNA > 500)
#HT <- NormalizeData(object = HT, verbose = FALSE)
HT <- FindVariableFeatures(object = HT, selection.method = "vst", nfeatures = 2000)
tcr <- read.csv("HT-filtered_contig_annotations.csv")
clono <- read.csv("HT-clonotypes.csv")
tcr <- tcr[!duplicated(tcr$barcode), ]
names(tcr)[names(tcr) == "raw_clonotype_id"] <- "clonotype_id"
#clono <- read.csv("clonotypes.csv")
tcr <- merge(tcr, clono)
rownames(tcr) <- tcr[,2]
tcr[,2] <- NULL
HT <- AddMetaData(object=HT, metadata=tcr)
HEART.data <- Read10X_h5("HEART.h5")
HEART <- CreateSeuratObject(counts = HEART.data, project = "IMMUNE_stim", min.cells = 5)
HEART$stim <- "HEART"
#HEART <- subset(x = HEART, subset = nFeature_RNA > 500)
HEART <- NormalizeData(object = HEART, verbose = FALSE)
HEART <- FindVariableFeatures(object = HEART, selection.method = "vst", nfeatures = 2000)
tcr <- read.csv("HEART-filtered_contig_annotations.csv")
clono <- read.csv("HEART-clonotypes.csv")
tcr <- tcr[!duplicated(tcr$barcode), ]
names(tcr)[names(tcr) == "raw_clonotype_id"] <- "clonotype_id"
#clono <- read.csv("clonotypes.csv")
tcr <- merge(tcr, clono)
rownames(tcr) <- tcr[,2]
tcr[,2] <- NULL
HEART <- AddMetaData(object=HEART, metadata=tcr)
save(WT, HT,HEART,file="stp1-three-sampl-with-tcr.Rdata")
#2.1find integration anchors
immune.anchors <- FindIntegrationAnchors(object.list = list(WT, HT,HEART), dims = 1:20)
save(immune.anchors,file="stp2-immuneanchors-90min.Rdata")
#2.2 integration data
immune.combined <- IntegrateData(anchorset = immune.anchors, dims = 1:20)
#3. Perform an integrated analysis######
DefaultAssay(immune.combined) <- "integrated"
immune.combined <- ScaleData(immune.combined, verbose = FALSE)
#Dimplot,DimHeatmap,VizDimReduction
immune.combined <- RunPCA(immune.combined, npcs = 30, verbose = FALSE)
#3.4 reduction and Clustering
immune.combined <- RunUMAP(immune.combined, reduction = "pca", dims = 1:20,seed.use = 1)
#[["percent.mt"]] <- PercentageFeatureSet(immune.combined, pattern = "^MT-")
#VlnPlot(immune.combined, features = c("nFeature_RNA", "nCount_RNA", "percent.mt"), ncol = 3)
#immune.combined <- subset(immune.combined, subset = nFeature_RNA > 200 & nFeature_RNA < 2500)
#immune.combined <- RunUMAP(immune.combined, reduction = "pca", dims = 1:20,seed.use = 1)
#DimPlot(immune.combined, reduction = "umap",label = T)#
immune.combined <- FindNeighbors(immune.combined, reduction = "pca", dims = 1:20)
#immune.combined <- FindClusters(immune.combined, resolution = 0.6)
save(immune.combined,file="stp3-immune.combined.Rdata")

###########
load("stp3-immune.combined.Rdata")
DimPlot(immune.combined, reduction = "umap",label = T)#
DimPlot(immune.combined, reduction = "umap", split.by = "stim",label = T
        #      ,cols = col
)
tab.1=table(immune.combined@meta.data$stim,immune.combined@active.ident) 
balloonplot(tab.1)

#FeaturePlot(immune.combined, features = "Cd3g",label =F,cols =c("lightgrey", "red"),min.cutoff = 1)
#FeaturePlot(immune.combined, features = "Cd4",label =F,cols =c("lightgrey", "red"),min.cutoff = 1)
#FeaturePlot(immune.combined, features = "Cd8a",label =F,cols =c("lightgrey", "red"),min.cutoff = 0.5)
#FeaturePlot(immune.combined, features = "Pdcd1",label =F,cols =c("lightgrey", "red"),min.cutoff =0.5)


immune.combined <- RenameIdents(immune.combined,`Monocytes` = "Monocytes")#
immune.combined <- RenameIdents(immune.combined,`NK` = "NK")#
immune.combined <- RenameIdents(immune.combined,`DC` = "DC")#
immune.combined <- RenameIdents(immune.combined,`Neutrophils` = "Neutrophils")#
immune.combined <- RenameIdents(immune.combined,`B cells` = "B cells")#
immune.combined <- RenameIdents(immune.combined,`T cells` = "T cells")#

DimPlot(immune.combined, reduction = "umap",label = T)#

DimPlot(immune.combined, reduction = "umap", split.by = "stim",label =F
        #      ,cols = col
)
tab.1=table(immune.combined@meta.data$stim,immune.combined@active.ident) 
DimPlot(immune.combined, reduction = "umap",label = T)
immune.combined<- subset(immune.combined, idents =c("T cells"))#get subset
DimPlot(immune.combined, reduction = "umap",label = T)

immune.combined <- ScaleData(immune.combined, verbose = FALSE)
immune.combined <- RunPCA(immune.combined, npcs = 30, verbose = FALSE)
immune.combined <- RunUMAP(immune.combined, reduction = "pca", dims = 1:20,seed.use = 2)
immune.combined <- FindNeighbors(immune.combined, reduction = "pca", dims = 1:20)
immune.combined <- FindClusters(immune.combined, resolution = 0.4)
DimPlot(immune.combined, reduction = "umap",label = T)

save(immune.combined,file="step5tell.Rdata")

FeaturePlot(immune.combined, features = "chain")

Idents(immune.combined) <- immune.combined$seurat_clusters#


#############VOLCANOL
b.interferon.response <- FindMarkers(immune.combined, ident.1 = "B", ident.2 = "A",logfc.threshold = 0.0,
                                     verbose = FALSE, min.pct = 0.3
)
nrDEG=b.interferon.response
colnames(nrDEG)
colnames(nrDEG)=c("adj.P.Val","logFC","pct.1","pct.2","pvalue")
colnames(nrDEG)
nrDEG$sign <- ifelse(nrDEG$adj.P.Val < 0.05 & abs(nrDEG$logFC) > 0.2,rownames(nrDEG),NA)

#####################################################
#nrDEG=na.omit(nrDEG)#####


#####################################################
nrDEG$group <- as.factor(ifelse(nrDEG$adj.P.Val < 0.05 & abs(nrDEG$logFC) > 0.2,ifelse(nrDEG$logFC > 0.2,'up-regulated','down-regulated'),'not-significant'))

nrDEG$sign=NA############

table(nrDEG$group)
nrDEG$sign <- ifelse(rownames(nrDEG)%in%markers,rownames(nrDEG),NA)
nrDEG$adj.P.Val <- ifelse(nrDEG$adj.P.Val < 1e-40,1e-40,nrDEG$adj.P.Val)
ggplot( nrDEG, aes(x = logFC, y = -log10(adj.P.Val), color = group)) +
  geom_point(alpha=0.6, size = 1.5) +
  coord_cartesian(xlim =c(-5, 5), ylim = c(0, 40))+#
  theme_bw(base_size = 15) +
  theme(panel.grid.minor = element_blank(),panel.grid.major = element_blank()) +
  geom_hline(yintercept=1.301 ,linetype=4) +
  geom_vline(xintercept=c(-0.2,0.2) ,linetype=4 ) +
  scale_color_manual(name = "", values = c("red", "blue", "grey90"), limits = c("up-regulated", "down-regulated", "not-significant")) +
  geom_label_repel(aes(label=sign), fontface="bold", color="black",  max.overlaps = getOption("ggrepel.max.overlaps", default = 50),
                   
                   box.padding=unit(1, "lines"),
                   point.padding=unit(0.25, "lines"), 
                   segment.colour = "grey50"


# if (!require("devtools")) {  install.packages("devtools")}install.packages("devtools")devtools::install_github("mattfemia/clonotypr")
# 
# library(devtools)
# devtools::install_github("mattfemia/clonotypr")
# 
# library(clonotypr)


